/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class WinBase {
    public static native int getLastError();

    public static native long nGetModuleHandle(long var0);

    public static long GetModuleHandle(@Nullable ByteBuffer moduleName) {
        if (Checks.CHECKS) {
            Checks.checkNT2Safe(moduleName);
        }
        return WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(moduleName));
    }

    public static native int nGetModuleFileName(long var0, long var2, int var4);

    public static int GetModuleFileName(long hModule, ByteBuffer lpFilename) {
        return WinBase.nGetModuleFileName(hModule, MemoryUtil.memAddress(lpFilename), lpFilename.remaining() >> 1);
    }

    public static native long nLoadLibrary(long var0);

    public static long LoadLibrary(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT2(name);
        }
        return WinBase.nLoadLibrary(MemoryUtil.memAddress(name));
    }

    public static native long nGetProcAddress(long var0, long var2);

    public static long GetProcAddress(long handle, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.check(handle);
            Checks.checkNT1(name);
        }
        return WinBase.nGetProcAddress(handle, MemoryUtil.memAddress(name));
    }

    public static native int nFreeLibrary(long var0);

    public static boolean FreeLibrary(long handle) {
        if (Checks.CHECKS) {
            Checks.check(handle);
        }
        return WinBase.nFreeLibrary(handle) != 0;
    }

    static {
        Library.initialize();
    }
}

