/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;

public abstract class StructBuffer<T extends Struct<T>, SELF extends StructBuffer<T, SELF>>
extends CustomBuffer<SELF>
implements Iterable<T> {
    protected StructBuffer(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
        super(address, container, mark, position, limit, capacity);
    }

    @Override
    public int sizeof() {
        return ((Struct)this.getElementFactory()).sizeof();
    }

    public SELF put(T value) {
        int sizeof = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(((Pointer.Default)value).address(), this.address + Integer.toUnsignedLong(this.nextPutIndex()) * (long)sizeof, sizeof);
        return (SELF)((StructBuffer)this.self());
    }

    @Override
    public Iterator<T> iterator() {
        return new StructIterator<T>(this.address, this.container, this.getElementFactory(), this.position, this.limit);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        T factory = this.getElementFactory();
        int fence = this.limit;
        int sizeof = ((Struct)factory).sizeof();
        for (int i = this.position; i < fence; ++i) {
            action.accept(((Struct)factory).create(this.address + Integer.toUnsignedLong(i) * (long)this.sizeof(), this.container));
        }
    }

    @Override
    public Spliterator<T> spliterator() {
        return new StructSpliterator<T>(this.address, this.container, this.getElementFactory(), this.position, this.limit);
    }

    protected abstract T getElementFactory();

    private static class StructSpliterator<T extends Struct<T>>
    implements Spliterator<T> {
        private long address;
        @Nullable
        private ByteBuffer container;
        private T factory;
        private int index;
        private int fence;

        StructSpliterator(long address, @Nullable ByteBuffer container, T factory, int position, int limit) {
            this.address = address;
            this.container = container;
            this.factory = factory;
            this.index = position;
            this.fence = limit;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            if (this.index < this.fence) {
                action.accept(((Struct)this.factory).create(this.address + Integer.toUnsignedLong(this.index++) * (long)((Struct)this.factory).sizeof(), this.container));
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Spliterator<T> trySplit() {
            StructSpliterator<T> structSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo < mid) {
                this.index = mid;
                StructSpliterator<T> structSpliterator2 = new StructSpliterator<T>(this.address, this.container, this.factory, lo, this.index);
                structSpliterator = structSpliterator2;
            } else {
                structSpliterator = null;
            }
            return structSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17744;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            int i;
            Objects.requireNonNull(action);
            try {
                int sizeof = ((Struct)this.factory).sizeof();
                for (i = this.index; i < this.fence; ++i) {
                    action.accept(((Struct)this.factory).create(this.address + Integer.toUnsignedLong(i) * (long)sizeof, this.container));
                }
            }
            finally {
                this.index = i;
            }
        }

        @Override
        public Comparator<? super T> getComparator() {
            throw new IllegalStateException();
        }
    }

    private static class StructIterator<T extends Struct<T>>
    implements Iterator<T> {
        private long address;
        @Nullable
        private ByteBuffer container;
        private T factory;
        private int index;
        private int fence;

        StructIterator(long address, @Nullable ByteBuffer container, T factory, int position, int limit) {
            this.address = address;
            this.container = container;
            this.factory = factory;
            this.index = position;
            this.fence = limit;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.fence;
        }

        @Override
        public T next() {
            if (Checks.CHECKS && this.fence <= this.index) {
                throw new NoSuchElementException();
            }
            return (T)((Struct)this.factory).create(this.address + Integer.toUnsignedLong(this.index++) * (long)((Struct)this.factory).sizeof(), this.container);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            int i;
            Objects.requireNonNull(action);
            try {
                int sizeof = ((Struct)this.factory).sizeof();
                for (i = this.index; i < this.fence; ++i) {
                    action.accept(((Struct)this.factory).create(this.address + Integer.toUnsignedLong(i) * (long)sizeof, this.container));
                }
            }
            finally {
                this.index = i;
            }
        }
    }
}

