/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BonePose;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.Physics;
import com.esotericsoftware.spine.PhysicsConstraint;
import com.esotericsoftware.spine.Posed;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SliderData;
import com.esotericsoftware.spine.SliderPose;
import com.esotericsoftware.spine.Slot;

public class Slider
extends Constraint<Slider, SliderData, SliderPose> {
    private static final float[] offsets = new float[6];
    Bone bone;

    public Slider(SliderData sliderData, Skeleton skeleton) {
        super(sliderData, new SliderPose(), new SliderPose());
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (sliderData.bone != null) {
            this.bone = ((Bone[])skeleton.bones.items)[sliderData.bone.index];
        }
    }

    @Override
    public void update(Skeleton skeleton, Physics physics) {
        SliderPose sliderPose = (SliderPose)this.applied;
        if (sliderPose.mix == 0.0f) {
            return;
        }
        Animation animation = ((SliderData)this.data).animation;
        if (this.bone != null) {
            if (!this.bone.active) {
                return;
            }
            if (((SliderData)this.data).local) {
                ((BonePose)this.bone.applied).validateLocalTransform(skeleton);
            }
            sliderPose.time = ((SliderData)this.data).offset + (((SliderData)this.data).property.value(skeleton, (BonePose)this.bone.applied, ((SliderData)this.data).local, offsets) - ((SliderData)this.data).property.offset) * ((SliderData)this.data).scale;
            sliderPose.time = ((SliderData)this.data).loop ? animation.duration + sliderPose.time % animation.duration : Math.max(0.0f, sliderPose.time);
        }
        Bone[] boneArray = (Bone[])skeleton.bones.items;
        int[] nArray = animation.bones.items;
        int n = animation.bones.size;
        for (int i = 0; i < n; ++i) {
            ((BonePose)boneArray[nArray[i]].applied).modifyLocal(skeleton);
        }
        animation.apply(skeleton, sliderPose.time, sliderPose.time, ((SliderData)this.data).loop, null, sliderPose.mix, ((SliderData)this.data).additive ? Animation.MixBlend.add : Animation.MixBlend.replace, Animation.MixDirection.in, true);
    }

    @Override
    void sort(Skeleton skeleton) {
        Constraint[] constraintArray;
        if (this.bone != null && !((SliderData)this.data).local) {
            skeleton.sortBone(this.bone);
        }
        skeleton.updateCache.add(this);
        Bone[] boneArray = (Bone[])skeleton.bones.items;
        int[] nArray = ((SliderData)this.data).animation.bones.items;
        int n = ((SliderData)this.data).animation.bones.size;
        for (int i = 0; i < n; ++i) {
            constraintArray = boneArray[nArray[i]];
            constraintArray.sorted = false;
            skeleton.sortReset(constraintArray.children);
            skeleton.constrained((Posed)constraintArray);
        }
        Animation.Timeline[] timelineArray = (Animation.Timeline[])((SliderData)this.data).animation.timelines.items;
        Slot[] slotArray = (Slot[])skeleton.slots.items;
        constraintArray = (Constraint[])skeleton.constraints.items;
        PhysicsConstraint[] physicsConstraintArray = (PhysicsConstraint[])skeleton.physics.items;
        int n2 = skeleton.physics.size;
        int n3 = ((SliderData)this.data).animation.timelines.size;
        for (int i = 0; i < n3; ++i) {
            Animation.Timeline timeline = timelineArray[i];
            if (timeline instanceof Animation.SlotTimeline) {
                Animation.SlotTimeline slotTimeline = (Animation.SlotTimeline)((Object)timeline);
                skeleton.constrained(slotArray[slotTimeline.getSlotIndex()]);
                continue;
            }
            if (timeline instanceof Animation.PhysicsConstraintTimeline) {
                Animation.PhysicsConstraintTimeline physicsConstraintTimeline = (Animation.PhysicsConstraintTimeline)timeline;
                if (physicsConstraintTimeline.constraintIndex == -1) {
                    for (int j = 0; j < n2; ++j) {
                        skeleton.constrained(physicsConstraintArray[j]);
                    }
                    continue;
                }
                skeleton.constrained(constraintArray[physicsConstraintTimeline.constraintIndex]);
                continue;
            }
            if (!(timeline instanceof Animation.ConstraintTimeline)) continue;
            Animation.ConstraintTimeline constraintTimeline = (Animation.ConstraintTimeline)((Object)timeline);
            skeleton.constrained(constraintArray[constraintTimeline.getConstraintIndex()]);
        }
    }
}

