/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.esotericsoftware.spine.SkeletonViewer;

class SkeletonViewerAtlas
extends TextureAtlas {
    private final SkeletonViewer viewer;
    private FileHandle atlasFile;
    private final TextureAtlas.AtlasRegion fake;

    public SkeletonViewerAtlas(SkeletonViewer skeletonViewer, FileHandle fileHandle) {
        Object object;
        this.viewer = skeletonViewer;
        this.atlasFile = this.findAtlasFile(fileHandle);
        if (this.atlasFile != null) {
            object = new TextureAtlas.TextureAtlasData(this.atlasFile, this.atlasFile.parent(), false);
            Gdx.app.postRunnable(new Runnable(){
                final /* synthetic */ TextureAtlas.TextureAtlasData val$atlasData;
                final /* synthetic */ SkeletonViewer val$viewer;
                {
                    this.val$atlasData = textureAtlasData;
                    this.val$viewer = skeletonViewer;
                }

                @Override
                public void run() {
                    boolean bl = true;
                    boolean bl2 = false;
                    int n = this.val$atlasData.getPages().size;
                    for (int i = 0; i < n; ++i) {
                        TextureAtlas.TextureAtlasData.Page page = this.val$atlasData.getPages().get(i);
                        if (page.pma) {
                            bl2 = true;
                        }
                        if (page.minFilter == Texture.TextureFilter.Linear && page.magFilter == Texture.TextureFilter.Linear) continue;
                        bl = false;
                        break;
                    }
                    this.val$viewer.ui.linearCheckbox.setChecked(bl);
                    this.val$viewer.ui.pmaCheckbox.setChecked(bl2);
                }
            });
            try {
                this.load((TextureAtlas.TextureAtlasData)object);
            }
            catch (Throwable throwable) {
                System.out.println("Error loading atlas: " + this.atlasFile.file().getAbsolutePath());
                throwable.printStackTrace();
                skeletonViewer.ui.toast("Error loading atlas: " + this.atlasFile.name());
                this.atlasFile = null;
            }
        }
        object = new Pixmap(32, 32, Pixmap.Format.RGBA8888);
        ((Pixmap)object).setColor(new Color(1.0f, 1.0f, 1.0f, 0.33f));
        ((Pixmap)object).fill();
        this.fake = new TextureAtlas.AtlasRegion(new Texture((Pixmap)object), 0, 0, 32, 32);
        ((Pixmap)object).dispose();
    }

    private FileHandle findAtlasFile(FileHandle fileHandle) {
        String string = fileHandle.name();
        for (String string2 : SkeletonViewer.startSuffixes) {
            for (String string3 : SkeletonViewer.endSuffixes) {
                for (String string4 : SkeletonViewer.dataSuffixes) {
                    FileHandle fileHandle2;
                    String string5 = string2 + string4 + string3;
                    if (!string.endsWith(string5) || (fileHandle2 = this.findAtlasFile(fileHandle, string.substring(0, string.length() - string5.length()))) == null) continue;
                    return fileHandle2;
                }
            }
        }
        return this.findAtlasFile(fileHandle, string);
    }

    private FileHandle findAtlasFile(FileHandle fileHandle, String string) {
        for (String string2 : SkeletonViewer.startSuffixes) {
            for (String string3 : SkeletonViewer.endSuffixes) {
                for (String string4 : SkeletonViewer.atlasSuffixes) {
                    FileHandle fileHandle2 = fileHandle.sibling(string + string2 + string4 + string3);
                    if (!fileHandle2.exists()) continue;
                    return fileHandle2;
                }
            }
        }
        return null;
    }

    @Override
    public TextureAtlas.AtlasRegion findRegion(String string) {
        FileHandle fileHandle;
        TextureAtlas.AtlasRegion atlasRegion = super.findRegion(string);
        if (atlasRegion == null && (fileHandle = this.viewer.skeletonFile.sibling(string + ".png")).exists()) {
            Texture texture = new Texture(fileHandle);
            texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            atlasRegion = new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight());
            atlasRegion.name = string;
        }
        return atlasRegion != null ? atlasRegion : this.fake;
    }

    public long lastModified() {
        return this.atlasFile == null ? 0L : this.atlasFile.lastModified();
    }
}

