/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;

public class SkeletonData {
    String name;
    final Array<BoneData> bones = new Array(true, 0, BoneData[]::new);
    final Array<SlotData> slots = new Array(true, 0, SlotData[]::new);
    final Array<Skin> skins = new Array(true, 0, Skin[]::new);
    Skin defaultSkin;
    final Array<EventData> events = new Array(true, 0, EventData[]::new);
    final Array<Animation> animations = new Array(true, 0, Animation[]::new);
    final Array<ConstraintData> constraints = new Array(true, 0, ConstraintData[]::new);
    float x;
    float y;
    float width;
    float height;
    float referenceScale = 100.0f;
    String version;
    String hash;
    float fps = 30.0f;
    String imagesPath;
    String audioPath;

    public Array<BoneData> getBones() {
        return this.bones;
    }

    public BoneData findBone(String string) {
        if (string == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        BoneData[] boneDataArray = (BoneData[])this.bones.items;
        int n = this.bones.size;
        for (int i = 0; i < n; ++i) {
            if (!boneDataArray[i].name.equals(string)) continue;
            return boneDataArray[i];
        }
        return null;
    }

    public SlotData findSlot(String string) {
        if (string == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        SlotData[] slotDataArray = (SlotData[])this.slots.items;
        int n = this.slots.size;
        for (int i = 0; i < n; ++i) {
            if (!slotDataArray[i].name.equals(string)) continue;
            return slotDataArray[i];
        }
        return null;
    }

    public Skin findSkin(String string) {
        if (string == null) {
            throw new IllegalArgumentException("skinName cannot be null.");
        }
        for (Skin skin : this.skins) {
            if (!skin.name.equals(string)) continue;
            return skin;
        }
        return null;
    }

    public Array<Skin> getSkins() {
        return this.skins;
    }

    public EventData findEvent(String string) {
        if (string == null) {
            throw new IllegalArgumentException("eventDataName cannot be null.");
        }
        for (EventData eventData : this.events) {
            if (!eventData.name.equals(string)) continue;
            return eventData;
        }
        return null;
    }

    public Array<Animation> getAnimations() {
        return this.animations;
    }

    public Animation findAnimation(String string) {
        if (string == null) {
            throw new IllegalArgumentException("animationName cannot be null.");
        }
        Animation[] animationArray = (Animation[])this.animations.items;
        int n = this.animations.size;
        for (int i = 0; i < n; ++i) {
            if (!animationArray[i].name.equals(string)) continue;
            return animationArray[i];
        }
        return null;
    }

    public <T extends ConstraintData> T findConstraint(String string, Class<T> clazz) {
        if (string == null) {
            throw new IllegalArgumentException("constraintName cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        ConstraintData[] constraintDataArray = (ConstraintData[])this.constraints.items;
        int n = this.constraints.size;
        for (int i = 0; i < n; ++i) {
            ConstraintData constraintData = constraintDataArray[i];
            if (!clazz.isInstance(constraintData) || !constraintData.name.equals(string)) continue;
            return (T)constraintData;
        }
        return null;
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }
}

