/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public final class BufferUtils {
    static Array<ByteBuffer> unsafeBuffers = new Array();
    static int allocatedUnsafe = 0;

    public static void copy(float[] src, Buffer dst, int numFloats, int offset) {
        if (dst instanceof ByteBuffer) {
            dst.limit(numFloats << 2);
        } else if (dst instanceof FloatBuffer) {
            dst.limit(numFloats);
        }
        BufferUtils.copyJni(src, dst, numFloats, offset);
        dst.position(0);
    }

    public static FloatBuffer newFloatBuffer(int numFloats) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(numFloats * 4);
        buffer.order(ByteOrder.nativeOrder());
        return buffer.asFloatBuffer();
    }

    public static ByteBuffer newByteBuffer(int numBytes) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(numBytes);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public static IntBuffer newIntBuffer(int numInts) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(numInts * 4);
        buffer.order(ByteOrder.nativeOrder());
        return buffer.asIntBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeUnsafeByteBuffer(ByteBuffer buffer) {
        int size = buffer.capacity();
        Array<ByteBuffer> array = unsafeBuffers;
        synchronized (array) {
            if (!unsafeBuffers.removeValue(buffer, true)) {
                throw new IllegalArgumentException("buffer not allocated with newUnsafeByteBuffer or already disposed");
            }
        }
        allocatedUnsafe -= size;
        BufferUtils.freeMemory(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer newUnsafeByteBuffer(int numBytes) {
        ByteBuffer buffer = BufferUtils.newDisposableByteBuffer(numBytes);
        buffer.order(ByteOrder.nativeOrder());
        allocatedUnsafe += numBytes;
        Array<ByteBuffer> array = unsafeBuffers;
        synchronized (array) {
            unsafeBuffers.add(buffer);
        }
        return buffer;
    }

    private static native void freeMemory(ByteBuffer var0);

    private static native ByteBuffer newDisposableByteBuffer(int var0);

    private static native void copyJni(float[] var0, Buffer var1, int var2, int var3);
}

